/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import java.util.regex.Pattern;

public class GitRef {
    static final String REFS = "refs/";
    public static final String REFS_REMOTES = "refs/remotes/";
    public static final String REFS_TAGS = "refs/tags/";
    public static final String REFS_HEADS = "refs/heads/";
    private String ref;

    private GitRef(String string) {
        this.ref = string;
    }

    static GitRef refFromString(String string) {
        return new GitRef(string);
    }

    protected String ref() {
        return this.ref;
    }

    public String shortName() {
        TYPE type = this.type();
        if (type == null) {
            return this.ref;
        }
        switch (type) {
            case REMOTE: {
                return this.ref.substring(REFS_REMOTES.length());
            }
            case HEAD: {
                return this.ref.substring(REFS_HEADS.length());
            }
            case TAG: {
                return this.ref.substring(REFS_TAGS.length());
            }
        }
        return this.ref;
    }

    public TYPE type() {
        if (this.ref.startsWith(REFS_HEADS)) {
            return TYPE.HEAD;
        }
        if (this.ref.startsWith(REFS_TAGS)) {
            return TYPE.TAG;
        }
        if (this.ref.startsWith(REFS_REMOTES)) {
            return TYPE.REMOTE;
        }
        return null;
    }

    public String toString() {
        return this.ref;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GitRef)) {
            return false;
        }
        GitRef other = (GitRef)obj;
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getRemoteName() {
        if (this.type() != TYPE.REMOTE) {
            return null;
        }
        String shortName = this.shortName();
        return shortName.split(Pattern.quote("/"))[0];
    }

    public String getRemoteBranchName() {
        if (this.type() != TYPE.REMOTE) {
            return null;
        }
        String shortName = this.shortName();
        return shortName.split(Pattern.quote("/"))[1];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        HEAD,
        REMOTE,
        TAG;

    }
}

